/**
* Simulates the underlying vphysics object forward by N ticks, storing the intermediate states to arrays and setting entity_set to the end state
*
* @param entity_sim Entity to simulate
* @param entity_set Entity to update state
* @param nticks     Number of ticks to simulate
* @param vel        New velocities
* @param avel       New angular velocities
* @param pos        New positions
* @param ang        New angles
* @return Status; -1 for failure and 0 for success
*/
native int JQOLV_SimAndSetCore(int entity_sim, int entity_set, int nticks, float[] vel, float[] avel, float[] pos, float[] ang);

/**
* Print state of phys object
*
* @param entity Entity to target
*/
native void JQOLV_DumpState(int entity);
